/*
 * ReaderControll.h
 *
 *  Created on: 14.10.2009
 *      Author: stefan.detter
 */

#ifndef READERCONTROLL_H_
#define READERCONTROLL_H_

#include <QObject>
#include <QSet>
#include <QrfeTraceModule>

#include <QrfeReaderInterfaceGlobal>

class Application;
class Reader;

class QPushButton;
class QCheckBox;
class QSpinBox;
class QProgressBar;
class QLabel;
class QTimer;

class ReaderControll : public QObject, QrfeTraceModule
{
	Q_OBJECT

public:
	ReaderControll(Application* application, QPushButton* startButton, QSpinBox* timeSpinBox, QCheckBox* infinitCheckBox, QProgressBar* scanProgress, QLabel* scanLabel, QWidget* secondsWidget, QLabel* warningLabel, QObject* parent = 0);
	virtual ~ReaderControll();

public slots:
	void activateInfiniteScan();

	void readerSelected(Reader* reader);
	void readerUnselected();

	void startButtonClicked();

	void startInventory();
	void stopInventory();

	void multiplexISR();

	void updateGUI();

	void infiniteToggled(bool yes);

signals:
    void inventoryAboutToStart();

private:
	void startInventoryOfReader(Reader* reader);
	void stopInventoryOfReader(Reader* reader);

    void pauseInventoryOfReader(Reader* reader);
    void continueInventoryOfReader(Reader* reader);

public:
	bool inventoryActive();

private:
	Application* 	m_application;
	bool			m_inventoryActive;

	bool			m_readerSelected;
	QString			m_activeReader;

	QTimer*			m_multiplexTimer;
	bool			m_multiplexReaderOn;
	uint			m_multiplexCurrentIndex;
	QString			m_multiplexCurrentReader;
    QSet<QString>   m_multiplexStartedReader;

	QTimer*			m_scanTimer;
	uint			m_scanCurrentTime;
	uint 			m_scanMaxTime;
	QPushButton* 	m_startButton;
	QSpinBox* 		m_timeSpinBox;
	QCheckBox* 		m_infinitCheckBox;
	QProgressBar* 	m_scanProgress;
	QLabel*			m_scanLabel;
	QWidget* 		m_secondsWidget;
	QLabel* 		m_warningLabel;
};

#endif /* READERCONTROLL_H_ */
